currentStage = -1;
// in milliseconds since 1st Jan. 1970, date when the next stage starts
nextStageAt = 0;

current = document.getElementById('current');
countdown = document.getElementById('countdown');
next = document.getElementById('next');

// in milliseconds
updatePeriod = 100;

function updateText(obj, val) {
    obj.textContent = val;
    // obj.offsetHeight;
}

function nextStage() {
    currentStage += 1;
    if (currentStage >= stages.length) {
        updateText(countdown, 'Done!');
        updateText(current, '');
        updateText(next, '');
    } else {
        updateText(current, stages[currentStage]['content']);
        if ( 1 + currentStage == stages.length ) {
            updateText(next, 'Next: Done!');
        } else {
            updateText(next,
                       'Next: ' + stages[currentStage + 1]['content']
                       + ' (' + stages[currentStage + 1]['duration'] + 's)');
        }
        nextStageAt = new Date().getTime() +
            1000 * stages[currentStage]['duration'];
        updateCountdown();
    }
}

function updateCountdown() {
    var current = new Date().getTime();
    var remaining = Math.ceil(nextStageAt - current);
    if (remaining <= 0) {
        nextStage();
    } else {
        updateText(countdown, '' + Math.ceil(remaining/1000.0));
        setTimeout(updateCountdown, updatePeriod);
    }
}

nextStage();
